
class DanishRevengeMessage expands CriticalEventLowPlus;

#exec AUDIO IMPORT FILE="Sounds\Revenge.wav" NAME="RevengeOneWav" GROUP="DanishRevenge"
var(Messages) localized string RevengeOne, RevengeNote,  RevengeTrailer;

static function string GetString(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,	// Killer
	optional PlayerReplicationInfo RelatedPRI_2,	// Other
	optional Object OptionalObject
	)
{
	if (PlayerReplicationinfo(OptionalObject) == RelatedPRI_1 && RelatedPRI_1 != None)
		return Default.RevengeOne;
	else if (RelatedPRI_2 != None)
	{
		if (RelatedPRI_1 != None)
		{
			return RelatedPRI_1.PlayerName@Default.RevengeNote@RelatedPRI_2.PlayerName$Default.RevengeTrailer;
		}
	}
	return "";
}

static simulated function ClientReceive(
	PlayerPawn P,
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,	// Killer
	optional PlayerReplicationInfo RelatedPRI_2,	// Other
	optional Object OptionalObject
	)
{
	Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, P.PlayerReplicationInfo);

	if (RelatedPRI_1 != P.PlayerReplicationInfo)
	{
		P.PlaySound(sound'SpreeSound',, 4.0);
		return;
	}
	P.ClientPlaySound(Sound'RevengeOneWav',, true);
}

defaultproperties;
{
RevengeNote="took revenge on"
RevengeOne="Oh yeah! you got revenge!"
}

